import express from "express";
import cookieParser from "cookie-parser";
import serialize from "node-serialize";
import dotenv from "dotenv";
import winston from "winston";

dotenv.config();
const app = express();
app.set("view engine", "ejs");
app.use(cookieParser());

const logger = winston.createLogger({
  level: "debug",
  format: winston.format.combine(winston.format.simple(), winston.format.colorize({ all: true })),
  transports: [new winston.transports.Console()],
});

const profileObject = {
  name: process.env.NAME,
  country: process.env.COUNTRY,
  city: process.env.CITY,
};
const profileCookie = new Buffer.from(serialize.serialize(profileObject)).toString("base64");

// middleware
app.use((request, response, next) => {
  logger.info(`[REQ] raw cookie: ${JSON.stringify(request.headers["cookie"])}`);
  next();
});

app.get("/", function (request, response) {
  if (request.cookies["profile"]) {
    const cookie = new Buffer.from(request.cookies["profile"], "base64").toString();
    const profile = serialize.unserialize(cookie);
    response.render("index", { profile });
  } else {
    response.cookie("profile", profileCookie, {
      maxAge: 60 * 1000,
    });
    response.render("index");
  }
});

app.get("/clear", function (request, response) {
  if (request.cookies["profile"]) {
    response.clearCookie("profile");
  }
  response.redirect("/");
});

const listener = app.listen(8080, () =>
  console.debug(`Server running on ${listener.address().address}:${listener.address().port}`)
);
